<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Responsive Charts</h1>
<div class="btn-group frameWidthButton d-none d-sm-inline-flex" style="padding-bottom: 2px;">
    <button id="smallChart" class="btn btn-default">Small</button>
    <button id="mediumChart" class="btn btn-default">Medium</button>
    <button id="largeChart" class="btn btn-default active">Large</button>
</div>

<section class="chartcontainer-wrapper">
    <div id="chartContainer"></div>
</section>

<?php
    $dataPoints = array(
        array("label"=> "Education", "y"=> 284935),
        array("label"=> "Entertainment", "y"=> 256548),
        array("label"=> "Lifestyle", "y"=> 245214),
        array("label"=> "Business", "y"=> 233464),
        array("label"=> "Music & Audio", "y"=> 200285),
        array("label"=> "Personalization", "y"=> 194422),
        array("label"=> "Tools", "y"=> 180337),
        array("label"=> "Books & Reference", "y"=> 172340),
        array("label"=> "Travel & Local", "y"=> 118187),
        array("label"=> "Puzzle", "y"=> 107530)
    );
?>

<script>
    var chart;
    jQuery("#smallChart").click(function(){jQuery(".chartcontainer-wrapper").css("width","40%");});
    jQuery("#mediumChart").click(function(){jQuery(".chartcontainer-wrapper").css("width","70%");});
    jQuery("#largeChart").click(function(){jQuery(".chartcontainer-wrapper").css("width","100%");});
    jQuery(".frameWidthButton .btn").click(function(){ jQuery(".frameWidthButton .btn").removeClass('active');jQuery(this).addClass('active');chart.render(); });

    window.onload = function () {
        chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            theme: "light2", // "light1", "light2", "dark1", "dark2"
            title: {
                text: "Top 10 Google Play Categories - till 2017"
            },
            axisY: {
                title: "Number of Apps"
            },
            data: [{
                type: "column",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>
<style>
    .btn-group {
        margin-top: 20px;
    }
</style>

<?php include '../footer.php'; ?>